/*
 * Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 * This is open source software; you can use, redistribute and/or modify 
 * it under the terms of the Open Software Licence v 2.1 as published by the Open 
 * Source Initiative.
 *
 * You should have received a copy of the Open Software Licence along with this
 * application; if not, contact the Open Source Initiative (http://opensource.org).
 */
package com.evelopers.unimod;

import java.net.URL;

import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ClasspathVariableInitializer;
import org.eclipse.jdt.core.JavaCore;

/**
 * @author vgurov
 * @version $Revision: 2$
 */
public class UniModCoreClasspathVariableInitializer extends ClasspathVariableInitializer {

	public static final String UNIMOD_CORE_PLUGIN_ID = "com.evelopers.unimod.core"; 
	public static final String UNIMOD_CORE_HOME = "UNIMOD_CORE_HOME"; 
	private static final String UNIMOD_CORE_PLUGIN_URL = "platform:/plugin/" + UNIMOD_CORE_PLUGIN_ID;
	public static final String UNIMOD_HOME = "UNIMOD_HOME";
	
    /* (non-Javadoc)
     * @see org.eclipse.jdt.core.ClasspathVariableInitializer#initialize(java.lang.String)
     */
    public void initialize(String variable) {
        if (UNIMOD_CORE_HOME.equals(variable)) {
            try {
                JavaCore.setClasspathVariable(UNIMOD_CORE_HOME, 
                		new Path(Platform.resolve(new URL(UNIMOD_CORE_PLUGIN_URL)).getPath()), null);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

}
