// $ANTLR : "FormulaCalculator.g" -> "FormulaCalculator.java"$

    package com.evelopers.unimod.analysis;

    import com.evelopers.unimod.analysis.executors.Substitution;
	import com.evelopers.unimod.parser.ConstNode;

import antlr.TreeParser;
import antlr.Token;
import antlr.collections.AST;
import antlr.RecognitionException;
import antlr.ANTLRException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.collections.impl.BitSet;
import antlr.ASTPair;
import antlr.collections.impl.ASTArray;


/**
 * Calculates formula using current Substitution. Use case:
 * <pre><code>
 *   FormulaCalculator calculator = new FormulaCalculator();
 *   calculator.calculate(ast, substitution);
 * </code></pre>
 */
public class FormulaCalculator extends antlr.TreeParser       implements FormulaCalculatorTokenTypes
 {

	private boolean calculatePredicate(AST predicate, Substitution substitution) {
		AST op1 = predicate.getFirstChild();
        AST op2 = op1.getNextSibling();
        String variableName;
        ConstNode constNode;
        if (op1.getType() == IDENT && op2.getType() == CONST_NUM) {
            variableName = op1.getText();
            constNode = (ConstNode) op2;
        	return substitution.getPredicateValue(variableName, predicate.getType(), constNode.getObjectValue());
        } else if (op2.getType() == IDENT && op1.getType() == CONST_NUM) {
            variableName = op2.getText();
            constNode = (ConstNode) op1;
        	return substitution.getPredicateValue(variableName, getReflected(predicate.getType()), constNode.getObjectValue());
        } else {
            reportWarning("predicate " + predicate + " skippped");
            variableName = null;
            constNode = null;
            return false;
        }
	}
	
	private boolean calculateOr(AST or, Substitution substitution) throws RecognitionException {
        for (AST child = or.getFirstChild(); child != null; child = child.getNextSibling()) {
        	if (calculate(child, substitution)) {
        		return true;
        	}
        }
        return false;
	}
	
	private boolean calculateAnd(AST and, Substitution substitution) throws RecognitionException {
        for (AST child = and.getFirstChild(); child != null; child = child.getNextSibling()) {
        	if (! calculate(child, substitution)) {
        		return false;
        	}
        }
        return true;
	}
	
	private int getReflected(int type) {
		switch (type) {
			case EQUAL: return EQUAL;
			case NEQUAL: return NEQUAL;
			case GE: return LE;
			case LE: return GE;
			case GT: return LT;
			case LT: return GT;
			default: throw new IllegalArgumentException();
		}
	}
public FormulaCalculator() {
	tokenNames = _tokenNames;
}

/**
 * Calculates formula using current substitution
 *
 * @param _t AST tree that represents the formula to calculate
 * @param substitution current substitution for variables
 */
	public final boolean  calculate(AST _t,
		Substitution substitution
	) throws RecognitionException {
		boolean value;
		
		AST calculate_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST or = null;
		AST and = null;
		AST not = null;
		AST id = null;
		AST eq = null;
		AST ne = null;
		AST ge = null;
		AST gt = null;
		AST le = null;
		AST lt = null;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case OR:
		{
			or = (AST)_t;
			match(_t,OR);
			_t = _t.getNextSibling();
			value = calculateOr(or, substitution);
			break;
		}
		case AND:
		{
			and = (AST)_t;
			match(_t,AND);
			_t = _t.getNextSibling();
			value = calculateAnd(and, substitution);
			break;
		}
		case NOT:
		{
			not = (AST)_t;
			match(_t,NOT);
			_t = _t.getNextSibling();
			value = ! calculate(not.getFirstChild(), substitution);
			break;
		}
		case IDENT:
		{
			id = (AST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			value = substitution.getBooleanVarValue(id.getText());
			break;
		}
		case EQUAL:
		{
			eq = (AST)_t;
			match(_t,EQUAL);
			_t = _t.getNextSibling();
			value = calculatePredicate(eq, substitution);
			break;
		}
		case NEQUAL:
		{
			ne = (AST)_t;
			match(_t,NEQUAL);
			_t = _t.getNextSibling();
			value = calculatePredicate(ne, substitution);
			break;
		}
		case GE:
		{
			ge = (AST)_t;
			match(_t,GE);
			_t = _t.getNextSibling();
			value = calculatePredicate(ge, substitution);
			break;
		}
		case GT:
		{
			gt = (AST)_t;
			match(_t,GT);
			_t = _t.getNextSibling();
			value = calculatePredicate(gt, substitution);
			break;
		}
		case LE:
		{
			le = (AST)_t;
			match(_t,LE);
			_t = _t.getNextSibling();
			value = calculatePredicate(le, substitution);
			break;
		}
		case LT:
		{
			lt = (AST)_t;
			match(_t,LT);
			_t = _t.getNextSibling();
			value = calculatePredicate(lt, substitution);
			break;
		}
		case TRUE:
		{
			AST tmp1_AST_in = (AST)_t;
			match(_t,TRUE);
			_t = _t.getNextSibling();
			value = true;
			break;
		}
		case FALSE:
		{
			AST tmp2_AST_in = (AST)_t;
			match(_t,FALSE);
			_t = _t.getNextSibling();
			value = false;
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
		return value;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"TRUE",
		"FALSE",
		"OR",
		"AND",
		"NOT",
		"LPAREN",
		"RPAREN",
		"EQUAL",
		"NEQUAL",
		"GE",
		"GT",
		"LE",
		"LT",
		"IDENT",
		"CONST_BOOL",
		"CONST_NUM",
		"WS",
		"DIGIT",
		"LETTER",
		"NAME",
		"CONST_BOOL_OR_IDENT"
	};
	
	}
	
