/*
 * Copyright (c) 1999-2005 eVelopers Corporation. All rights reserved.
 *
 * This is open source software; you can use, redistribute and/or modify 
 * it under the terms of the Open Software Licence v 2.1 as published by the Open 
 * Source Initiative.
 *
 * You should have received a copy of the Open Software Licence along with this
 * application; if not, contact the Open Source Initiative (http://opensource.org).
 */
package com.evelopers.unimod.analysis.executors;

import java.util.Iterator;
import java.util.List;

import com.evelopers.unimod.analysis.TypeInfo;

class DiscreteRangePredicateExecutorBuilder extends RangePredicateExecutorBuilder {

    public DiscreteRangePredicateExecutorBuilder(TypeInfo typeInfo) {
        super(typeInfo);
    }
    
    protected void filterIntervals(List intervals) {
        /* Remove intervals that contain no points */
        for (Iterator i = intervals.iterator(); i.hasNext();) {
            Interval interval = (Interval) i.next();
            if (! interval.isLeftIncluded() && ! interval.isRightIncluded() &&
                interval.getMax().compareTo(getTypeInfo().next(interval.getMin())) == 0) {
                i.remove();
            }
        }
    }
}
