/*
 * Copyright (c) 1999-2005 eVelopers Corporation. All rights reserved.
 *
 * This is open source software; you can use, redistribute and/or modify 
 * it under the terms of the Open Software Licence v 2.1 as published by the Open 
 * Source Initiative.
 *
 * You should have received a copy of the Open Software Licence along with this
 * application; if not, contact the Open Source Initiative (http://opensource.org).
 */
package com.evelopers.unimod.analysis.executors;

import java.util.HashSet;
import java.util.Set;

import com.evelopers.unimod.parser.ExprParser;
import com.evelopers.unimod.parser.ExprTokenTypes;

/**
 * @uml.dependency   supplier="com.evelopers.unimod.analysis.executors.DiscreteSetPredicateExecutor" stereotypes="Basic::Create"
 */
class DiscreteSetPredicateExecutorBuilder implements PredicateExecutorBuilder {
    protected final static Object OTHER_VALUE = new Object();    
    private Set usedValues = new HashSet();

    public void addPredicate(int predicateType, Object value) {
        if (predicateType == ExprTokenTypes.EQUAL || 
            predicateType == ExprTokenTypes.NEQUAL) {
            usedValues.add(value);
        } else {
            throw new IllegalArgumentException("Bad predicate type: " + 
                    ExprParser._tokenNames[predicateType]);
        }
    }
    
    public PredicateExecutor createPredicateExecutor() {
        if (isOtherValueUsed()) {
            usedValues.add(OTHER_VALUE);
        }
        Object[] values = usedValues.toArray();
        return new DiscreteSetPredicateExecutor(values);
    }

    protected Set getUsedValues() {
        return usedValues;
    }
    
    protected boolean isOtherValueUsed() {
        return true;
    }
}
