/*
 * Copyright (c) 1999-2005 eVelopers Corporation. All rights reserved.
 *
 * This is open source software; you can use, redistribute and/or modify 
 * it under the terms of the Open Software Licence v 2.1 as published by the Open 
 * Source Initiative.
 *
 * You should have received a copy of the Open Software Licence along with this
 * application; if not, contact the Open Source Initiative (http://opensource.org).
 */
package com.evelopers.unimod.analysis.executors;


class Interval {
    final private Comparable min;
    final private Comparable max;
    final private boolean leftIncluded;
    final private boolean rightIncluded;
        
    public Interval(Comparable min, boolean included, Comparable max, boolean included2) {
        this.min = min;
        leftIncluded = included;
        this.max = max;
        rightIncluded = included2;
    }

    public Comparable getMin() {
        return min;
    }
    
    public boolean isLeftIncluded() {
        return leftIncluded;
    }
    
    public Comparable getMax() {
        return max;
    }
    
    public boolean isRightIncluded() {
        return rightIncluded;
    }

    public String toString() {
        return (isLeftIncluded() ? "[" : "(") +
               getMin() + ", " + getMax() +
               (isRightIncluded() ? "]" : ")");
    }
}