/*
 * Copyright (c) 1999-2005 eVelopers Corporation. All rights reserved.
 *
 * This is open source software; you can use, redistribute and/or modify 
 * it under the terms of the Open Software Licence v 2.1 as published by the Open 
 * Source Initiative.
 *
 * You should have received a copy of the Open Software Licence along with this
 * application; if not, contact the Open Source Initiative (http://opensource.org).
 */
package com.evelopers.unimod.analysis.executors;


public class LongSet {
    private long[] values;

    private int size;

    public LongSet() {
        this(16);
    }

    public LongSet(int capacity) {
        capacity = Math.max(0, capacity);
        this.size = 0;
        this.values = new long[capacity];
    }

    public void add(long value) {
        if (size > 0 && value <= values[size - 1]) {
            throw new IllegalArgumentException(
                    "Elements should be added in the growing order");
        }
        if (size == values.length) {
            long[] newValues = new long[values.length << 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            values = newValues;
        }
        values[size] = value;
        size++;
    }

    public boolean contains(long value) {
        return indexOf(value) >= 0;
    }

    public long get(int index) {
        return values[index];
    }

    public int size() {
        return size;
    }

    public boolean isEmpty() {
        return size() == 0;
    }

    public boolean isNotEmpty() {
        return size() != 0;
    }

    public int indexOf(long value) {
        int low = 0;
        int high = size - 1;

        while (low <= high) {
            int mid = (low + high) >> 1;
            long midVal = values[mid];

            if (midVal < value) {
                low = mid + 1;
            } else if (midVal > value) {
                high = mid - 1;
            } else {
                return mid; 
            }
        }
        return -1;
    }
}
