/*
 * Copyright (c) 1999-2005 eVelopers Corporation. All rights reserved.
 *
 * This is open source software; you can use, redistribute and/or modify 
 * it under the terms of the Open Software Licence v 2.1 as published by the Open 
 * Source Initiative.
 *
 * You should have received a copy of the Open Software Licence along with this
 * application; if not, contact the Open Source Initiative (http://opensource.org).
 */
package com.evelopers.unimod.analysis.executors;

class Neighborhood implements Comparable {
    public Comparable point;
    public boolean left;
    public boolean right;
    
    public Neighborhood(Comparable point) {
        this.left = true;
        this.right = true;
        this.point = point;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Neighborhood) {
            Neighborhood that = (Neighborhood) obj;
            return this.point.equals(that.point);
        } else {
            return false;
        }
    }
    
    public int hashCode() {
        return point.hashCode();
    }

    public int compareTo(Object o) {
        Neighborhood that = (Neighborhood) o;
        return point.compareTo(that.point);
    }
}