/*
 * Copyright (c) 1999-2005 eVelopers Corporation. All rights reserved.
 *
 * This is open source software; you can use, redistribute and/or modify 
 * it under the terms of the Open Software Licence v 2.1 as published by the Open 
 * Source Initiative.
 *
 * You should have received a copy of the Open Software Licence along with this
 * application; if not, contact the Open Source Initiative (http://opensource.org).
 */
package com.evelopers.unimod.analysis.executors;

import com.evelopers.unimod.parser.ExprTokenTypes;

interface PredicateExecutorBuilder {

    /**
     * Adds predicate to set of predicates of the {@link PredicateExecutor}.
     *  
     * @param predicateType one of
     * <ul>
     *   <li>{@link ExprTokenTypes#EQUAL} for [x == value]</li>
     *   <li>{@link ExprTokenTypes#NEQUAL} for [x != value]</li>
     *   <li>{@link ExprTokenTypes#GT} for [x > value]</li>
     *   <li>{@link ExprTokenTypes#GE} for [x >= value]</li>
     *   <li>{@link ExprTokenTypes#LT} for [x < value]</li>
     *   <li>{@link ExprTokenTypes#LE} for [x <= value]</li>
     * </ul> 
     * @param value the constant that is used to compare the variable with
     */
    void addPredicate(int predicateType, Object value);

    PredicateExecutor createPredicateExecutor(); 
}
