/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.compilation;

import com.evelopers.unimod.core.ModelElement;
import com.evelopers.unimod.core.stateworks.*;
import com.evelopers.unimod.parser.ParserException;

/**
 * Compilation process listener. {@link com.evelopers.unimod.compilation.StateMachineCompiler} will
 * notify listener about all error found during compilation.
 *  
 * @author Vadim Gurov
 * @version $Revision: 1$
 */
public interface CompilationListener {

	/**
	 * Given model element has null name
	 * 
	 * @param sm
	 * @param me
	 */
	void nullName(StateMachine sm, ModelElement me);

	/**
	 * Given contorlled object handler has null implementation class
	 * 
	 * @param sm
	 * @param co
	 */
	void nullImplClass(StateMachine sm, ControlledObjectHandler co);

	/**
	 * Given event provider handler has null implementation class
	 * 
	 * @param sm
	 * @param ep
	 */
	void nullImplClass(StateMachine sm, EventProviderHandler ep);
	
	/**
	 * Given state has null state type
	 * 
	 * @param sm
	 * @param s
	 */
	void nullStateType(StateMachine sm, State s);

	/**
	 * Given action has incorrect format.
	 * 
	 * @param sm
	 * @param me Transition or State that owns action
	 * @param a
	 */
	void incorrectActionIdentifier(StateMachine sm, ModelElement me, Action a);
	
	/**
	 * Given guard condition has incorrect expression
	 * 
	 * @param sm
	 * @param t Transition that owns Guard
	 * @param c
	 * @param e parser exception with format errors details
	 */
	void incorrectExpression(StateMachine sm, Transition t, Guard c, ParserException e);

    /**
     * Action identifier has unresolved link to class element
     * 
     * @param sm
     * @param owner
     * @param e
     * @param coName
     */
    void unresolvedClassElement(StateMachine sm, ModelElement owner, Action e, String coName);

    /**
     * Given controlled object handler has no action with name that was used in given action
     *
     * @param sm
     * @param owner
     * @param e
     * @param co
     * @param actionName
     */
    void unresolvedAction(StateMachine sm, ModelElement owner, Action e, ControlledObjectHandler co, String actionName);
}
