/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.compilation;

import com.evelopers.unimod.core.stateworks.ControlledObjectHandler;

/**
 * This interface should be implemented in case when
 * actions associated with methods of ControlledObject
 * could be resolved.
 * <p/>
 * For given controlled object handler and action name implementor
 * should return return-type of operation or <code>null</code>
 * if controlled object doesn't have an operation with the
 * name same to given action.
 *
 * @author Maxim Mazin
 * @version Revision: 1
 */
public interface OperationResolver {
    
    public static class VOID {};
    
    /**
     * For given <code>object</code> and <code>actionName</code> this
     * method returns return-type of operation or <code>null</code>
     * if <code>object</code> doesn't have an operation with the
     * name same to given <code>actionName</code>.
     * For methods with "void" return type this method must return {@link VOID} constant.
     *
     * @param object controlled object handler to explore
     * @param actionName name of operation to search
     * @return return-type of object's operation with name eqaul to actionName
     * or <code>null</code> if object has no operation with name
     * <code>actionName</code>
     */
    Class getOperationType(ControlledObjectHandler object, String actionName);
}