/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.contract;

import java.util.StringTokenizer;

import com.evelopers.unimod.runtime.StateMachineConfig;
import com.evelopers.unimod.runtime.StateMachinePath;

/**
 * Converts StateMachinePath and StateMachineConfig into String and vice versa. 
 */
public class RuntimeContract {
    
    private RuntimeContract(){}

    public static StateMachinePath decodeStateMachinePath(String s) {
        StringTokenizer tokenizer = new StringTokenizer(s, "/:");
        StateMachinePath path = new StateMachinePath(tokenizer.nextToken());
        
        while (tokenizer.hasMoreTokens()) {
            String includingState = tokenizer.nextToken();
            String stateMachineName = tokenizer.nextToken();
            path = new StateMachinePath(path, includingState, stateMachineName);
        }

        return path;
    }
    
    public static String encode(StateMachinePath smp) {
        StringBuffer buffer = new StringBuffer();

        if (smp.getSuperStateMachinePath() != null) {
            buffer.append(smp.getSuperStateMachinePath()).
                    append(':').
                    append(smp.getIncludingState());
        }

        buffer.append('/').append(smp.getStateMachine());

        return buffer.toString();
    }
    
    public static StateMachineConfig decodeStateMachineConfig(String s) {
        return new StateMachineConfig(s);
    }
    
    public static String encode(StateMachineConfig c) {
        return c.getActiveState();
    }
   
}
