/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.core;

import com.evelopers.common.exception.*;

/**
 * Visitor methods may throw this exception to the original caller of accept method. 
 * 
 * @author Vadim Gurov
 * @version $Revision: 1$
 */
public class VisitorException extends SystemException {

    /**
     * @see SystemException#SystemException(Throwable)
     * @param nestedException original exception
     */
    public VisitorException(Throwable nestedException) {
        super(nestedException);
        initCause(nestedException);
    }

    /**
     * @see SystemException#SystemException(String)
     * @param message error message
     */
    public VisitorException(String message) {
        super(message);
    }

	/**
	 * @see CommonException#CommonException(Throwable, String)
	 * @param e original exception
	 * @param message error message
	 */
	public VisitorException(Throwable e, String message) {
	  super(e, message);
	  initCause(e);
	}


}
