/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.core.stateworks;

import com.evelopers.unimod.core.ModelElement;

/**
 * <p>
 * Action implements such State Machine abstractions as
 * input action, output action, send event to state machine action
 * </p>
 *
 * @author Vadim Gurov
 * @version $Revision: 1$
 */
public class Action extends ModelElement {

    protected String identifier = null;
    protected ClassElement object;
    protected String actionName;
    
	/**
	 * Creates action with given controllable object and name.
	 *
	 * @param identifier an identifier like o1.z2
	 */
	protected Action(String identifier) {
		this.identifier = identifier;
	}

	/**
	 * Returns identifier
	 * 
	 * @return identifier
	 */
	public String getIdentifier() {
		return identifier;
	}

	/**
     * @return Returns the action.
     */
    public String getActionName() {
        return actionName;
    }
    
    /**
     * @return Returns the object.
     */
    public ClassElement getObject() {
        return object;
    }
    
    /**
     * @param action The action to set.
     */
    public void setActionName(String actionName) {
        this.actionName = actionName;
    }
    
    /**
     * @param object The object to set.
     */
    public void setObject(ClassElement object) {
        this.object = object;
    }
	
	/**
	 * Compares two actions. Actions equal if their actions names and their
	 * controllable objects equal.
	 *
	 * @param o another object
	 *
	 * @return boolean
	 */
	public boolean equals(Object o) {
		if (!(o instanceof Action)) {
			return false;
		} else {
			return getIdentifier().equals(((Action)o).getIdentifier());
		}
	}

	/**
	 * Returns hashcode of controllable object and action name
	 *
	 * @return hashcode
	 */
	public int hashCode() {
		return identifier.hashCode();
	}

	/**
	 * Returns action's identifier
	 *
	 * @return action's identifier
	 */
	public String toString() {
		return getIdentifier();
	}
	
}
