/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.core.stateworks;



/**
  * EvnetProvider object handler
  * 
  * @author vgurov
  * @version $Revision: 1$
  */
public class EventProviderHandler extends ClassElement {

    public static final String EVENT_PROVIDER_STEREOTYPE = "eventprovider";

    /** @link dependency 
     * @label creates in runtime
     */
    /*# com.evelopers.unimod.runtime.EventHandler lnkEventHandler; */

    /** @link dependency 
     * @label creates in runtime
     */
    /*# EventProvider lnkEventProvider; */

    protected EventProviderHandler(String objectName, String implementationClassName) {
	    super(objectName, EVENT_PROVIDER_STEREOTYPE);
        setImplName(implementationClassName);
	}
	
    protected void addIncomingAssociation(Association association) {
        throw new UnsupportedOperationException("EventProviderHandler can not has incoming associations");
    }
    
    protected void addOutgoingAssociation(Association association) {
        if (association == null || (association.getSource() != this) || !(association.getTarget() instanceof StateMachine)) {
            throw new IllegalArgumentException("Incorrect outgoing association");
        }
        
        super.addOutgoingAssociation(association);
    }
    
    public void setImplName(String implName) {
        super.setImplName(implName);
    }
    
	public boolean equals(Object o) {
		if (!(o instanceof EventProviderHandler)) {
			return false;
		}

		return super.equals(o);
	}
   
}
