/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.debug;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.evelopers.common.exception.SystemException;
import com.evelopers.unimod.runtime.ExceptionHandler;
import com.evelopers.unimod.runtime.context.StateMachineContext;

/**
 * @author vgurov
 */
public class ExceptionHandlerImpl implements ExceptionHandler {

    private static Log log = LogFactory.getLog(ExceptionHandlerImpl.class);
    
    /* (non-Javadoc)
     * @see com.evelopers.unimod.runtime.ExceptionHandler#handleException(com.evelopers.unimod.runtime.context.StateMachineContext, com.evelopers.common.exception.SystemException)
     */
    public void handleException(StateMachineContext context, SystemException e) {
        if (log != null) {
            log.error(e.getChainedTrace());
        }
    }

}
