/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.debug.app;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import com.evelopers.unimod.debug.Params;
import com.evelopers.unimod.debug.ThreadConfigManager;
import com.evelopers.unimod.debug.protocol.ThreadInfo;
import com.evelopers.unimod.runtime.ControlledObject;
import com.evelopers.unimod.runtime.context.StateMachineContext;

/**
 */
public class ThreadManager implements ControlledObject {

    private Map threads = new HashMap();

    private boolean suspendAllThreads = false;
    
    private ThreadConfigManager threadConfigManager;

    ThreadManager(){}

    /**
     * @param threadConfigManager The threadConfigManager to set.
     */
    void setThreadConfigManager(ThreadConfigManager threadConfigManager) {
        this.threadConfigManager = threadConfigManager;
    }
    
	/**
	*@unimod.action.descr suspend event thread
	*/
	public void z1(StateMachineContext context) {
		ThreadInfo ti = (ThreadInfo)context.getEventContext().getParameter(Params.Event.THREAD_INFO);

		threads.put(ti, new Object());
	}

	/**
	*@unimod.action.descr resume event thread
	*/
	public void z2(StateMachineContext context) {
		ThreadInfo ti = (ThreadInfo)context.getEventContext().getParameter(Params.Event.THREAD_INFO);
		
		Object lock = threads.get(ti);
		synchronized (lock) {
		    lock.notifyAll();
		}
		
		threads.remove(ti);
	}

	/**
	*@unimod.action.descr resume all threads
	*/
	public void z3(StateMachineContext context) {
		for (Iterator i = threads.keySet().iterator(); i.hasNext();) {
		    Object lock = threads.get(i.next());

			synchronized (lock) {
			    lock.notifyAll();
			}
		}
		
		threads.clear();
		suspendAllThreads = false;
		
		// reset thread management config store
		// so after debugger will connect again, all threads will
		// start processing from the initial state
		threadConfigManager.resetAllThreadConfigs();
	}

	/**
	*@unimod.action.descr suspend all threads
	*/
	public void z4(StateMachineContext context) {
	    suspendAllThreads = true;
	}
	
	boolean needSuspend(ThreadInfo thread) {
	    if (suspendAllThreads) {
	        threads.put(thread, new Object());
	    }
	    
	    return threads.get(thread) != null;
	}
	
	Object getLock(ThreadInfo thread) {
	    return threads.get(thread);
	}	 
	
	ThreadInfo[] getSuspenedThreads() {
		Set s = threads.keySet();
		
		return (ThreadInfo[])s.toArray(new ThreadInfo[s.size()]);
	}

}
