/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.debug.debugger;

import com.evelopers.common.exception.CommonException;
import com.evelopers.unimod.runtime.ControlledObject;
import com.evelopers.unimod.runtime.EventProvider;
import com.evelopers.unimod.runtime.context.StateMachineContext;

/**
 * @author vgurov
 */
public interface UIManager extends EventProvider, ControlledObject {

	/**
    * Event must has associated THREAD_INFO parameter - ident of thread to make step in which 
	* @unimod.event.descr make step
	*/
	public static final String E23 = "e23";

	/**
	 * Event must has associated THREAD_INFO parameter - ident of thread to resume
	* @unimod.event.descr resume
	*/
	public static final String E24 = "e24";

	/**
	* @unimod.event.descr disconnect from app
	*/
	public static final String E25 = "e25";

	/**
	* @unimod.event.descr close debugger
	*/
	public static final String E26 = "e26";

	/**
	* @unimod.event.descr update model in debugged engine
	*/
	public static final String E27 = "e27";
	
	/**
	 * event context has parameter THREAD_INFO - ident of thread that was suspended
	*@unimod.action.descr app suspended on breakpoint
	*/
	public void z1(StateMachineContext context) throws CommonException;

	/**
	 * event context has parameter THREAD_INFO - ident of thread that was suspended
	*@unimod.action.descr app suspended on step
	*/
	public void z2(StateMachineContext context) throws CommonException;

	/**
	 * event context has parameter THREAD_INFO - ident of thread that was resumed
	*@unimod.action.descr app resumed
	*/
	public void z3(StateMachineContext context) throws CommonException;

	/**
	*@unimod.action.descr app has closed connection
	*/
	public void z4(StateMachineContext context) throws CommonException;

	/**
	*@unimod.action.descr app has sent unknown message
	*/
	public void z5(StateMachineContext context) throws CommonException;

	/**
	*@unimod.action.descr app has received unknown command 
	*/
	public void z6(StateMachineContext context) throws CommonException;

	/**
	*@unimod.action.descr new thread created
	*/
	public void z7(StateMachineContext context) throws CommonException;

	/**
	*@unimod.action.descr can't update model in debugged engine
	*/
	public void z8(StateMachineContext context) throws CommonException;
	
}
