/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.debug.debugger.console;

import java.io.FileInputStream;
import java.io.IOException;

import com.evelopers.common.exception.CommonException;
import com.evelopers.unimod.core.stateworks.Model;
import com.evelopers.unimod.debug.debugger.Debugger;
import com.evelopers.unimod.debug.protocol.JavaSpecificMessageCoder;
import com.evelopers.unimod.transform.xml.XMLToModel;

/**
 * @author vgurov
 */
public class ConsoleDebugger {

    public static void main(String[] args) throws CommonException, IOException {
        if (args.length < 3) {
            System.out.println("Usage:");
            System.out.println("ConsoleDebugger <hostname> <port> <model.xml>");
            return;
        }
        
        Model model = XMLToModel.load(new FileInputStream(args[2]));
        
        ConsoleManager cm = new ConsoleManager(model);
        BreakpointManagerImpl bm = new BreakpointManagerImpl(); 
        Debugger d = new Debugger(args[0], Integer.parseInt(args[1]), new JavaSpecificMessageCoder(), bm, cm);
        d.start();
    }
    
}
