/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.debug.protocol;

import java.io.Serializable;

/**
 * Abstract Message to interact between application and debugger 
 */
public abstract class Message implements Serializable {

    private int type;
    private ThreadInfo threadInfo;
    
    Message(int type, ThreadInfo threadInfo) {
        this.type = type;
        this.threadInfo = threadInfo;
    }
    
    public int getType() {
        return type;
    }
    
    /**
     * @return Returns the thread.
     */
    public ThreadInfo getThreadInfo() {
        return threadInfo;
    }
    
}
