/*
 * Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 * This is open source software; you can use, redistribute and/or modify 
 * it under the terms of the Open Software Licence v 2.1 as published by the Open 
 * Source Initiative.
 *
 * You should have received a copy of the Open Software Licence along with this
 * application; if not, contact the Open Source Initiative (http://opensource.org).
 */
package com.evelopers.unimod.debug.protocol;

import java.io.Serializable;

/**
 * Thread information - name and identifier
 * @author vgurov
 */
public class ThreadInfo implements Serializable {

    private String name;
    private int ident;
    
    public ThreadInfo(String name, int ident) {
        this.name = name;
        this.ident = ident;
    }
    
    /**
     * @return Returns the ident.
     */
    public int getIdent() {
        return ident;
    }
    
    /**
     * @return Returns the name.
     */
    public String getName() {
        return name;
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    public int hashCode() {
        return ident;
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object obj) {
        return getIdent() == ((ThreadInfo)obj).getIdent();
    }
    
    public String toString() {
        return name;
    }    
    
}
