/*
 * Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 * This is open source software; you can use, redistribute and/or modify 
 * it under the terms of the Open Software Licence v 2.1 as published by the Open 
 * Source Initiative.
 *
 * You should have received a copy of the Open Software Licence along with this
 * application; if not, contact the Open Source Initiative (http://opensource.org).
 */
package com.evelopers.unimod.debug.protocol.position;

import com.evelopers.unimod.contract.CoreContract;
import com.evelopers.unimod.core.ModelElement;
import com.evelopers.unimod.core.stateworks.Model;
import com.evelopers.unimod.runtime.StateMachinePath;
import com.evelopers.unimod.runtime.context.StateMachineContext;

public class ComeToStatePosition extends Position {

    private String state;
    
    public ComeToStatePosition(StateMachineContext context,StateMachinePath path, String state) {
        super(context, path);
        this.state = state;
    }
    
    public String getState() {
        return state;
    }

    /* (non-Javadoc)
     * @see com.evelopers.unimod.debug.protocol.position.Position#getContainer(com.evelopers.unimod.core.stateworks.Model)
     */
    public ModelElement getContainer(Model m) {
        return CoreContract.decodeState(getStateMachine(m), getState());
    }

    /* (non-Javadoc)
     * @see com.evelopers.unimod.debug.protocol.position.Position#getTarget(com.evelopers.unimod.core.stateworks.Model)
     */
    public ModelElement getTarget(Model m) {
        return getContainer(m);
    }
    
    public int hashCode() {
        return super.hashCode() ^ state.hashCode();
    }
    
    public boolean equals(Object o) {
        if (!(o instanceof ComeToStatePosition)) {
            return false;
        }
        
        return 
        	super.equals(o) && 
        	((ComeToStatePosition)o).getState().equals(getState());
    }
    
    public String toString() {
        return super.toString() + "Come to state " + state;
    }
    
}
