/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.debug.protocol.position;

import com.evelopers.unimod.contract.CoreContract;
import com.evelopers.unimod.core.ModelElement;
import com.evelopers.unimod.core.stateworks.Model;
import com.evelopers.unimod.core.stateworks.State;
import com.evelopers.unimod.runtime.StateMachinePath;
import com.evelopers.unimod.runtime.context.StateMachineContext;

/**
 * Before or after execution of on-enter output action in state
 */
public class OnEnterActionExecutionPosition extends ActionExecutionPosition {
    
    private String state;

    public OnEnterActionExecutionPosition(StateMachineContext context, StateMachinePath path, String state, String action, boolean before) {
        super(context, path, action, before);
        
        this.state = state;
    }
        
    public String getState() {
        return state;
    }
    
    /* (non-Javadoc)
     * @see com.evelopers.unimod.debug.protocol.position.Position#getContainer(com.evelopers.unimod.core.stateworks.Model)
     */
    public ModelElement getContainer(Model m) {
        return CoreContract.decodeState(getStateMachine(m), getState());
    }
    
    /* (non-Javadoc)
     * @see com.evelopers.unimod.debug.protocol.position.Position#getTarget(com.evelopers.unimod.core.stateworks.Model)
     */
    public ModelElement getTarget(Model m) {
        return CoreContract.decodeAction((State)getContainer(m), getAction());
    }

    public int hashCode() {
        return super.hashCode() ^ state.hashCode();
    }
    
    public boolean equals(Object o) {
        if (!(o instanceof OnEnterActionExecutionPosition)) {
            return false;
        }
        
        return 
        	super.equals(o) && 
        	((OnEnterActionExecutionPosition)o).getState().equals(getState());
    }
    
    /* (non-Javadoc)
     * @see com.evelopers.unimod.debug.protocol.position.ActionExecutionPosition#toString()
     */
    public String toString() {
        return super.toString() + "Execute output action " + getAction() + " in state " + getState();
    }
}
