/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.debug.protocol.position;

import java.io.Serializable;

import com.evelopers.unimod.contract.CoreContract;
import com.evelopers.unimod.core.ModelElement;
import com.evelopers.unimod.core.stateworks.Model;
import com.evelopers.unimod.core.stateworks.StateMachine;
import com.evelopers.unimod.runtime.StateMachinePath;
import com.evelopers.unimod.runtime.context.StateMachineContext;

/**
 * Indicates position in algorythm of event processing
 * 
 * @author Maxim Mazin
 * @version $Revision: 2$
 */
public abstract class Position implements Serializable {

    private StateMachinePath path;
    private StateMachineContext context;

    public Position(StateMachineContext context, StateMachinePath path) {
        if (path == null) {
            throw new IllegalArgumentException("StateMachinePath can't be null.");
        }
        
        this.context = context;
        this.path = path;
    }
    
    public StateMachinePath getPath() {
        return path;
    }

    /**
     * @return Returns the context.
     */
    public StateMachineContext getContext() {
        return context;
    }

    /**
     * @param context The context to set.
     */
    public void setContext(StateMachineContext context) {
        this.context = context;
    }
    
    /*
    public String toString() {
        try {
            StringBuffer buffer = new StringBuffer();
            new MessageFormat("position: {0} '{'\n").format(new Object[]{getClass().getName()}, buffer, null);
            BeanInfo beanInfo = Introspector.getBeanInfo(getClass());
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length; i++) {
                PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
                if (propertyDescriptor.getReadMethod() != null &&
                        propertyDescriptor.getWriteMethod() != null) {
                    String name = propertyDescriptor.getName();
                    Object value = propertyDescriptor.getReadMethod().invoke(this, new Object[0]);
                    String type = propertyDescriptor.getPropertyType().getName();
                    new MessageFormat("  {0}: {1} = {2}\n").format(new Object[]{name, type, value}, buffer, null);
                }
            }
            buffer.append("}\n");
            return buffer.toString();
        } catch (Exception e) {
            return super.toString();
        }
    }*/
    
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return "[" + path + "] ";
    }
    
    public int hashCode() {
        return 1;
    }
    
    /**
     * Returns container element for position.
     * For example, if position is execution of input action on transition, it
     * will return transition that holds guard with input action.
     * Returns State or Transition only. 
     * 
     * @param m
     * @return
     */
    public abstract ModelElement getContainer(Model m);

    /**
     * Returns target element of position.
     * 
     * @param m
     * @return
     */
    public abstract ModelElement getTarget(Model m);
    
    public StateMachine getStateMachine(Model m) {
        return CoreContract.decodeStateMachine(m, path.getStateMachine());
    }
    
    public boolean equals(Object o) {
        if (!(o instanceof Position)) {
            return false;
        }

        // we must not compare whole paths, because if we have
        // breakpoint installed in some state machine, it doesn't matter
        // with what path this state machine was executed - breakpoint must hit!        
        return this.getPath().getStateMachine().equals(((Position)o).getPath().getStateMachine());
    }
}
