/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.parser;

import antlr.Token;

/**
 * AST node for numeric constant
 * 
 * @author Vadim Gurov
 * @author Maxim Mazin:
 *  added default constructor
 *  moved assignment to <code>value</code> to <code>setText(String)</code>
 *  so <code>ConstNode</code> may be duplicated by <code>astFactory.dup(AST)</code>
 * @version $Revision: 2$
 */
public class ConstNode extends antlr.CommonAST {

    private int value;
    private Object objectValue; 

    /**
     * Does nothing. Used for duplicating.
     */
    public ConstNode() {
        super();
    }

	/**
	 * Creates const for given token.
	 * 
	 * @param t token
	 */
    public ConstNode(Token t) {
        super(t);
    }

    /**
     * Assigns value of constant.
     * @param text string presentation of constant value
     */
    public void setText(String text) {
        super.setText(text);
        value = Integer.parseInt(text);
    }

    /**
	 * Returns const int value. Called by Interpreter.
	 *  
	 * @return const int value
	 */
    public int getValue() {
        return value;
    }

    public Object getObjectValue() {
        return objectValue;
    }
    
    public void setObjectValue(Object objectValue) {
        this.objectValue = objectValue;
    }
}
