/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.resources;

import java.util.*;

/**
 * Singletone. Produce all constants in unimod.
 * 
 * @author Vadim Gurov
 * @version $Revision: 1$
 */
public class Constants {

  public static final String ACTION_IDENTIFIER_DELIMETER = "C1";
  public static final String SUBSTATES_DELIMETER = "C2";
  public static final String COMMENT_DELIMETER = "C3";
  public static final String TOGETHER_TOP_STATE_NAME = "C4";
  public static final String TOGETHER_DELIMETER = "C5";

    private static Constants instance = null;
    private ResourceBundle resources = null;
    private static String resourceName = "com.evelopers.unimod.resources.properties.Constants";

    public static Constants getConstants() {
        if (instance == null) {
            synchronized (Constants.class) {
                    if (instance == null) {
                        instance = new Constants();
                    }
            }
        }

      return instance;
    }

    private Constants() {
      resources = ResourceBundle.getBundle(resourceName);
    }

    public String getStringConstant(String key) {
      return resources.getString(key);
    }

    public int getIntConstant(String key) {
      return Integer.parseInt(resources.getString(key));
    }
}