/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.resources;

import java.util.*;
import java.text.*;

/**
 * Singletone. Produce all messages in unimod.
 * 
 * @author Vadim Gurov
 * @version $Revision: 1$
 */
public class Messages {

    public static final String TARGET_STATE_NULL = "E1";
    public static final String SOURCE_STATE_NULL = "E2";
    public static final String TRANSITION_NULL = "E3";
    public static final String INCORRECT_SOURCE_STATE = "E4";
    public static final String INCORRECT_TARGET_STATE = "E5";
    public static final String ACTION_NOT_FOUND = "E6";
    public static final String CREATE_OBJECT_ERROR = "E7";
    public static final String EXECUTE_METHOD_ERROR = "E8";
	public static final String RETURN_MUSTBE_INT = "E9";
	public static final String RETURN_MUSTBE_BOOL = "E91";
    public static final String SOURCE_MUSTBE_DOCUMENT = "E10";
    public static final String UNEXPECTED_EXCEPTION = "E11";
    public static final String TRANSFORMER_NOT_FOUND = "E12";
    public static final String INCORRECT_OBJECT = "E13";
    public static final String PARAMETER_NOT_FOUND = "E14";
    public static final String SOURCE_MUSTBE_STATEMACHINE = "E15";
    public static final String DUPLICATE_STATE_DEFENITION = "E16";
    public static final String TOGETHER_NODE_NOT_FOUND = "E17";
    public static final String TOGETHER_CREATE_DIARGAM = "E18";
    public static final String TOGETHER_CREATE_STATE = "E19";
    public static final String TOGETHER_CREATE_TRANSITION = "E20";
    public static final String TOGETHER_CREATE_PACKAGE = "E21";
    public static final String TOGETHER_CANT_CREATE_PACKAGE = "E22";
    public static final String SOURCE_MUSTBE_DIAGRAM = "E23";
    public static final String TOGETHER_DIAGRAM_NOT_FOUND = "E24";
    public static final String UNKNOWN_STATE = "E25";
    public static final String NO_INITIAL_STATE = "E26";
    public static final String ASSOCIATION_NULL = "E27";
    public static final String ASSOCIATION_INCORRECT = "E28";

    public static final String TOGETHER_PLUGIN_NAME = "plugin.name";

    private static Messages instance = null;
    private ResourceBundle resources = null;
    private static String resourceName = "com.evelopers.unimod.resources.properties.Messages";

    public static Messages getMessages() {
        if (instance == null) {
            synchronized (Messages.class) {
                    if (instance == null) {
                        instance = new Messages();
                    }
            }
        }

      return instance;
    }

    private Messages() {
      resources = ResourceBundle.getBundle(resourceName);
    }

    public String getMessage(String key) {
      return resources.getString(key);
    }

    public String getMessage(String key, Object[] parameters) {
      String msg = getMessage(key);

      return MessageFormat.format(msg, parameters);
    }

}


/*--- Formatted in eVelopers Java Convention Style on Tue, Nov 12, '02 ---*/
