/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.runtime;

import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.runtime.context.StateMachineContext;

/**
 * Base implementation of {@link EventProcessorListener}
 * @author Maxim Mazin
 */
public abstract class AbstractEventProcessorListener implements EventProcessorListener {

    public void afterInputActionExecution(StateMachineContext context,
            StateMachinePath path, String transition, 
            String inputAction, String value) {}
    
    public void afterOnEnterActionExecution(StateMachineContext context,
            StateMachinePath path, String state, 
            String outputAction) {}
    
    public void afterOutputActionExecution(StateMachineContext context,
            StateMachinePath path, String transition, 
            String outputAction) {} 
    
    public void afterSubmachineExecution(StateMachineContext context,
            Event event, StateMachinePath path, 
            String state, String subMachine) {}
    
    public void beforeInputActionExecution(StateMachineContext context,
            StateMachinePath path, String transition, 
            String inputAction) {}
    
    public void beforeOnEnterActionExecution(StateMachineContext context,
            StateMachinePath path, String state, 
            String outputAction) {}
    
    public void beforeOutputActionExecution(StateMachineContext context,
            StateMachinePath path, String transition, 
            String outputAction) {}

    public void beforeSubmachineExecution(StateMachineContext context, 
            Event e, StateMachinePath path, 
            String state, String subMachine) {}
    
    public void comeToState(StateMachineContext context, 
            StateMachinePath path, String state) {}
    
    public void compositeTargetState(StateMachineContext context,
            StateMachinePath path, String state) {}

    public void eventProcessingFinished(StateMachineContext context, 
            Event e, StateMachinePath path, 
            StateMachineConfig c) {}
    
    public void eventProcessingStarted(StateMachineContext context, 
            Event e, StateMachinePath path, 
            StateMachineConfig c) {}
    
    public void stateMachineCameToFinalState(StateMachineContext context,
            StateMachinePath path, StateMachineConfig config) {}
    
    public void transitionCandidate(StateMachineContext context,
            StateMachinePath path, String state, 
            Event event, String transition) {}

    public void transitionFound(StateMachineContext context,
            StateMachinePath path, String state, 
            Event event, String transition) {}

    public void transitionNotFound(StateMachineContext context,
            StateMachinePath path, String state, 
            Event event) {}
    
    public void eventSkipped(StateMachineContext context, 
            StateMachinePath path, String state, 
            Event event) {}

    public void transitionsOfSuperstate(StateMachineContext context,
            StateMachinePath path, String superstate, 
            Event event) {}    
}