/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.runtime;

import com.evelopers.common.exception.*;

/**
 * Wrapper for all exceptions that were thrown by input and output actions 
 * execution.
 * 
 * @author Vadim Gurov
 * @version $Revision: 1$
 */
public class EventProcessorException extends SystemException {

    /**
     * @see SystemException#SystemException(Throwable)
     * @param nestedException original exception
     */
    public EventProcessorException(Throwable nestedException) {
        super(nestedException);
    }

    /**
     * @see SystemException#SystemException(String)
     * @param message error message
     */
    public EventProcessorException(String message) {
        super(message);
    }

	/**
	 * @see CommonException#CommonException(Throwable, String)
	 * @param e original exception
	 * @param message error message
	 */
	public EventProcessorException(Throwable e, String message) {
	  super(e, message);
	}

}
