/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.runtime;

import com.evelopers.common.exception.SystemException;
import com.evelopers.unimod.runtime.context.StateMachineContext;

/**
 * <p>
 * Model engine client can implement this interface
 * and pass it to {@link AbstractEventProcessor} engine to be
 * able to recevie notifications from engine about exceptions.
 * </p>
 * <p>
 * Such approach is being used, because there are at least two models of runtime
 * event processing - synchronous and asynchronous. For synchronous model,
 * client could be notified about exceptions
 * with a help of {@link com.evelopers.unimod.runtime.ModelEngine#handle} method,
 * but in asynchronous this couldn't be made. So callback approach used for
 * both models.
 * </p>
 * 
 * @author Vadim Gurov
 * @author Maxim Mazin
 * @version $Revision: 1$
 */
public interface ExceptionHandler {

	/**
	 * Called by state machine engine when exception occurs
	 * during event processing
	 * 
	 * @param context state machine context
	 * @param e exception
	 */
	public void handleException(StateMachineContext context, SystemException e);

    /** @link dependency 
     * @label handles*/
    /*# EventProcessorException lnkEventProcessorException; */
}
