/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.runtime;

import java.io.Serializable;

/**
 * Implements state machine active state configuration.
 *
 * @author Maxim Mazin
 */
public class StateMachineConfig implements Serializable {
    
    private String activeState = null;

    public StateMachineConfig(String s) {
        activeState = s;
    }
    
	/**
	 * Returns state name
	 *
	 * @return state name
	 */
	public String getActiveState() {
		return activeState;
	}

    /**
     * Sets active state name
     * @param activeStateName new active state name to set
     */
    public void setActiveState(String activeState) {
        this.activeState = activeState;
    }

    public int hashCode() {
        return activeState.hashCode();
    }
    
    public boolean equals(Object o) {
        if (!(o instanceof StateMachineConfig)) {
            return false;
        }
        
        return activeState.equals(((StateMachineConfig)o).getActiveState());
    }
    
    public String toString() {
        return activeState == null ? "??" : activeState;
    }
    
}