/*
 * Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 * This is open source software; you can use, redistribute and/or modify 
 * it under the terms of the Open Software Licence v 2.1 as published by the Open 
 * Source Initiative.
 *
 * You should have received a copy of the Open Software Licence along with this
 * application; if not, contact the Open Source Initiative (http://opensource.org).
 */
package com.evelopers.unimod.runtime.config;

import com.evelopers.unimod.runtime.StateMachineConfigManager;
import com.evelopers.unimod.runtime.StateMachineConfig;
import com.evelopers.unimod.runtime.StateMachinePath;
import com.evelopers.unimod.runtime.context.StateMachineContext;

import java.util.Map;
import java.util.HashMap;

/**
 * In-memory config store implementation. Distinguishs configs for
 * the same state machine if it's included in different states. 
 * 
 * @author vgurov
 * @version $Revision: 1$
 */
public class DistinguishConfigManager implements StateMachineConfigManager {

    private Map configs = new HashMap();

    public void init(
            StateMachinePath path, StateMachineContext context, StateMachineConfig initialConfig) {
        setConfig(path, initialConfig);
    }

    public StateMachineConfig load(StateMachinePath path, StateMachineContext context) {
        return getConfig(path);
    }

    public void store(StateMachinePath path, StateMachineContext context, StateMachineConfig config) {
        setConfig(path, config);
    }

    public void dispose(
            StateMachinePath path, StateMachineContext context, StateMachineConfig finalConfig) {
        resetConfig(path);
    }

    protected StateMachineConfig getConfig(StateMachinePath path) {
        return (StateMachineConfig) configs.get(path);
    }

    protected void setConfig(StateMachinePath path, StateMachineConfig config) {
        configs.put(path, config);
    }

    protected void resetConfig(StateMachinePath path) {
        configs.remove(path);
    }
}
