/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.runtime.config;

import com.evelopers.unimod.runtime.StateMachineConfig;
import com.evelopers.unimod.runtime.StateMachineConfigManager;
import com.evelopers.unimod.runtime.StateMachinePath;
import com.evelopers.unimod.runtime.context.StateMachineContext;

/**
 * ConfigManager that ignores state machine path. So if state machine is included in different states, it
 * saves it's state during transition between states of parent state machine.
 */
public class SharedStateConfigManager implements StateMachineConfigManager {

    private StateMachineConfig config;
    
    /* (non-Javadoc)
     * @see com.evelopers.unimod.runtime.StateMachineConfigManager#init(com.evelopers.unimod.runtime.StateMachinePath, com.evelopers.unimod.runtime.context.StateMachineContext, com.evelopers.unimod.runtime.StateMachineConfig)
     */
    public void init(StateMachinePath path, StateMachineContext context,
            StateMachineConfig initialConfig) {
        config = initialConfig;
    }

    /* (non-Javadoc)
     * @see com.evelopers.unimod.runtime.StateMachineConfigManager#load(com.evelopers.unimod.runtime.StateMachinePath, com.evelopers.unimod.runtime.context.StateMachineContext)
     */
    public StateMachineConfig load(StateMachinePath path,
            StateMachineContext context) {
        return config;
    }

    /* (non-Javadoc)
     * @see com.evelopers.unimod.runtime.StateMachineConfigManager#store(com.evelopers.unimod.runtime.StateMachinePath, com.evelopers.unimod.runtime.context.StateMachineContext, com.evelopers.unimod.runtime.StateMachineConfig)
     */
    public void store(StateMachinePath path, StateMachineContext context,
            StateMachineConfig config) {
        this.config = config; 
    }

    /* (non-Javadoc)
     * @see com.evelopers.unimod.runtime.StateMachineConfigManager#dispose(com.evelopers.unimod.runtime.StateMachinePath, com.evelopers.unimod.runtime.context.StateMachineContext, com.evelopers.unimod.runtime.StateMachineConfig)
     */
    public void dispose(StateMachinePath path, StateMachineContext context,
            StateMachineConfig finalConfig) {
        config = null;
    }

}
