/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.runtime.interpretation;

import java.util.HashMap;
import java.util.Map;

import com.evelopers.unimod.contract.CoreContract;
import com.evelopers.unimod.core.stateworks.Model;
import com.evelopers.unimod.core.stateworks.State;
import com.evelopers.unimod.core.stateworks.StateMachine;
import com.evelopers.unimod.core.stateworks.StateType;
import com.evelopers.unimod.runtime.EventProcessorException;
import com.evelopers.unimod.runtime.ModelStructure;
import com.evelopers.unimod.runtime.StateMachineConfig;
import com.evelopers.unimod.runtime.StateMachineConfigManager;
import com.evelopers.unimod.runtime.StateMachinePath;

/**
 * Interpretation model structure implementation.
 *
 * @author Maxim Mazin
 */
class InterpretationModelStructure implements ModelStructure {
    private Model model;
    private Map stateMachineConfigManagers;

    public InterpretationModelStructure(Model model) {
        setModel(model);
        stateMachineConfigManagers = new HashMap();
    }
    
    /**
     * Call to this method during event processing is not allowed.
     * Also, call to this method after some event processing may
     * cause model engine crash, because new model may not content some
     * states or statemachines that was already saved by config managers.
     * @param model
     */
    void setModel(Model model) {
    	this.model = model;
    }

    public StateMachinePath getRootPath() {
        return 
        	new StateMachinePath(
        	        CoreContract.encode(model.getRootStateMachine()));
    }

    public StateMachineConfigManager getConfigManager(String stateMachineName) throws EventProcessorException {
        StateMachine stateMachine = CoreContract.decodeStateMachine(model, stateMachineName);
        StateMachineConfigManager configManager = (StateMachineConfigManager) stateMachineConfigManagers.get(stateMachineName);
        if (configManager == null) {
            String configManagerClassName = stateMachine.getConfigManagerClassName();
            configManager = InstantiateHelper.getStateMachineConfigManager(configManagerClassName);
            stateMachineConfigManagers.put(stateMachineName, configManager);
        }
        return configManager;
    }

    public StateMachineConfig getTopConfig(String stateMachine) {
        StateMachine machine = CoreContract.decodeStateMachine(model, stateMachine);
        State topState = machine.getTop();
        StateMachineConfig config = new StateMachineConfig(CoreContract.encode(topState));
        return config;
    }

    public boolean isFinal(String stateMachine, StateMachineConfig config) {
        StateMachine machine = CoreContract.decodeStateMachine(model, stateMachine);
        State state = CoreContract.decodeState(machine, config.getActiveState());
        
        return StateType.FINAL.equals(state.getType());
    }

    StateMachine getStateMachine(String stateMachine) {
        return CoreContract.decodeStateMachine(model, stateMachine);
    }
    
}