/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.transform;

import com.evelopers.common.exception.CommonException;
import com.evelopers.common.exception.SystemException;

/**
 * Thrown by any transformer.
 * 
 * @author Vadim Gurov
 * @version $Revision: 1$
 */
public class TransformException extends SystemException {

	/**
	 * @see CommonException#CommonException(String)
	 * @param message error message
	 */
	public TransformException(String message) {
	  super(message);
	}

	/**
	 * @see CommonException#CommonException(Throwable)
	 * @param e original exception
	 */
	public TransformException(Throwable e) {
	  super(e);
	}

	/**
	 * @see CommonException#CommonException(Throwable, String)
	 * @param e original exception
	 * @param message error message
	 */
	public TransformException(Throwable e, String message) {
	  super(e, message);
	}

}
