package com.evelopers.unimod.transform.source;

import java.io.InputStream;

import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class ExplicitClasspathResourceLoader extends ClasspathResourceLoader {
	public static final String CLASSLOADER = "classloader";
	private ClassLoader classLoader;
	
    /**
     *  This is abstract in the base class, so we need it
     */
    public void init( ExtendedProperties configuration)
    {
        rsvc.info("ExplicitClasspathResourceLoader : initialization starting.");
        this.classLoader = (ClassLoader) configuration.get(CLASSLOADER);
        rsvc.info("ExplicitClasspathResourceLoader : initialization complete.");
    }

	public synchronized InputStream getResourceStream(String name)
			throws ResourceNotFoundException {
		InputStream result = null;

		if (name == null || name.length() == 0) {
			throw new ResourceNotFoundException("No template name provided");
		}

		try {
			result = classLoader.getResourceAsStream(name);
		} catch (Exception e) {
			/*
			 * log and convert to a general Velocity ResourceNotFoundException
			 */
			throw new ResourceNotFoundException(e.getMessage());
		}

		return result;
	}
}
