header {
    package com.evelopers.unimod.analysis;

    import com.evelopers.unimod.analysis.executors.Substitution;
	import com.evelopers.unimod.parser.ConstNode;
}

/**
 * Calculates formula using current Substitution. Use case:
 * <pre><code>
 *   FormulaCalculator calculator = new FormulaCalculator();
 *   calculator.calculate(ast, substitution);
 * </code></pre>
 */
class FormulaCalculator extends TreeParser;
options {
    buildAST = false;
    importVocab = Expr;
	defaultErrorHandler = false;
}

{
	private boolean calculatePredicate(AST predicate, Substitution substitution) {
		AST op1 = predicate.getFirstChild();
        AST op2 = op1.getNextSibling();
        String variableName;
        ConstNode constNode;
        if (op1.getType() == IDENT && op2.getType() == CONST_NUM) {
            variableName = op1.getText();
            constNode = (ConstNode) op2;
        	return substitution.getPredicateValue(variableName, predicate.getType(), constNode.getObjectValue());
        } else if (op2.getType() == IDENT && op1.getType() == CONST_NUM) {
            variableName = op2.getText();
            constNode = (ConstNode) op1;
        	return substitution.getPredicateValue(variableName, getReflected(predicate.getType()), constNode.getObjectValue());
        } else {
            reportWarning("predicate " + predicate + " skippped");
            variableName = null;
            constNode = null;
            return false;
        }
	}
	
	private boolean calculateOr(AST or, Substitution substitution) throws RecognitionException {
        for (AST child = or.getFirstChild(); child != null; child = child.getNextSibling()) {
        	if (calculate(child, substitution)) {
        		return true;
        	}
        }
        return false;
	}
	
	private boolean calculateAnd(AST and, Substitution substitution) throws RecognitionException {
        for (AST child = and.getFirstChild(); child != null; child = child.getNextSibling()) {
        	if (! calculate(child, substitution)) {
        		return false;
        	}
        }
        return true;
	}
	
	private int getReflected(int type) {
		switch (type) {
			case EQUAL: return EQUAL;
			case NEQUAL: return NEQUAL;
			case GE: return LE;
			case LE: return GE;
			case GT: return LT;
			case LT: return GT;
			default: throw new IllegalArgumentException();
		}
	}
}

/**
 * Calculates formula using current substitution
 *
 * @param _t AST tree that represents the formula to calculate
 * @param substitution current substitution for variables
 */
calculate[Substitution substitution] returns [boolean value]
    :   or:OR		{value = calculateOr(or, substitution);}
    |   and:AND 	{value = calculateAnd(and, substitution);}
    |   not:NOT 	{value = ! calculate(not.getFirstChild(), substitution);}
    |   id:IDENT    {value = substitution.getBooleanVarValue(id.getText());}
    |   eq:EQUAL 	{value = calculatePredicate(eq, substitution);}
    |   ne:NEQUAL 	{value = calculatePredicate(ne, substitution);}
    |   ge:GE 		{value = calculatePredicate(ge, substitution);}
    |   gt:GT 		{value = calculatePredicate(gt, substitution);}
    |   le:LE 		{value = calculatePredicate(le, substitution);}
    |   lt:LT		{value = calculatePredicate(lt, substitution);}
    |   TRUE		{value = true;}
    | 	FALSE    	{value = false;}
    ;
