header {
    package com.evelopers.unimod.analysis;

	import java.util.Set;
	import java.util.HashSet;
}

/**
 * Gathers predicates and boolean variables. Set objectValues to 
 * constant nodes. Use case:
 * <pre><code>
 *   Gatherer gatherer = new Gatherer(typeInfoProvider);
 *   gatherer.gather(ast);
 *   SubstitutionBuilder builder = gatherer.getBuilder();
 *   Substitution substitution = builder.buildSubstitution();
 * </code></pre>
 * @deprecated
 */
class OldTypeInfoProviderBuilder extends TreeParser;
options {
    buildAST = false;
    importVocab = Expr;
	defaultErrorHandler = false;
}

{
	private Set booleanVariables = new HashSet();
	private Set intVariables = new HashSet();
	
	public TypeInfoProvider buildProvider() {
		return new TypeInfoProvider() {
            protected Set getValuesSet(String variableName) {
                return null;
            }
        
            protected Class getValueClass(String variableName) {
                return null;
            }
        
            protected int getType(String variableName) {
                if (booleanVariables.contains(variableName)) {
                    return TypeInfo.BOOLEAN.getType();
                } else if (intVariables.contains(variableName)) {
                    return TypeInfo.INT.getType();
                } else {
                    return -1;
                }
            }        
        };
	}
	
	public static TypeInfoProvider buildProvider(AST formula) throws RecognitionException {
		OldTypeInfoProviderBuilder builder = new OldTypeInfoProviderBuilder();
		builder.gather(formula);
		return builder.buildProvider();
	}
	
	private void addBooleanVariable(String variableName) throws RecognitionException {
		if (intVariables.contains(variableName)) {
		    throw new RecognitionException(variableName + " variable appears both in boolean and integer context");
        }
        booleanVariables.add(variableName);
	}
    
    private void addIntVariable(AST predicate) throws RecognitionException {
        AST op1 = predicate.getFirstChild();
        AST op2 = op1.getNextSibling();        
        String variableName = null;
        if (op1.getType() == IDENT) {
            variableName = op1.getText();
        } else if (op2.getType() == IDENT) {
            variableName = op2.getText();
        }
        if (variableName != null) {
            if (booleanVariables.contains(variableName)) {
                throw new RecognitionException(variableName + " variable appears both in boolean and integer context");
            }
            intVariables.add(variableName);
        }
    }
}

gather
    :   #(OR 	(gather)+)
    |   #(AND 	(gather)+)
    |   #(NOT 	(gather) )
    |   eq:	EQUAL 			{addIntVariable(eq);}
	| 	ne: NEQUAL 			{addIntVariable(ne);}
	| 	ge: GE 				{addIntVariable(ge);}
	|   le: LE 				{addIntVariable(le);}
	| 	gt: GT 				{addIntVariable(gt);}
	|   lt: LT 				{addIntVariable(lt);}
    |   id:	IDENT			{addBooleanVariable(id.getText());}
    |   (TRUE | FALSE)
    ;
    
