/*
 * Developed by eVelopers Corporation
 *
 * $Date: 19-Jul-05 13:23:02$
 *
 */
package com.evelopers.common.exception;

import java.text.MessageFormat;

/**
 * @author: aloukianova
 * @version $Revision: 1$
 */
public class ValidationError extends CommonException {
    //~ Instance fields ////////////////////////////////////////////////////////

    public static final int INVALID_LINE = -1; 
    public static final int TEST_NOT_IMPLEMENTED = 0;
    public static final int TEST_NOT_FOUND = 1;
    
    protected static final String[] errorMessages = new String[] {
            "Test '{0}' is not implemented.",
            "Test '{0}' is not registered."
    };
    
    private int errorType = INVALID_LINE;
    private String msg = null;
    
    private String test = null;
    private String token = null;
    private int tokenNumber = -1;
    private String propertyName = null;
    private int number = -1;
    private String line = null;

    //~ Constructors ///////////////////////////////////////////////////////////

    public ValidationError(String test, String token) {
        super((String)null);
        this.test = test;
        this.token = token;
    }
    
    public ValidationError(int errorType, String msg) {
    	super((String)null);
        this.errorType = errorType;
        this.msg = msg;
    }

    //~ Methods ////////////////////////////////////////////////////////////////

    public void setTokenNumber(int tokenNumber) {
        this.tokenNumber = tokenNumber;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setLine(String line) {
        this.line = line;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public String getPropertyName() {
        return propertyName;
    }

    public String getTest() {
        return test;
    }

    public String getToken() {
        return token;
    }

    public int getTokenNumber() {
        return tokenNumber;
    }

    public String getLine() {
        return line;
    }

    public int getNumber() {
        return number;
    }
    
    public String toString() {
        return getMessage();
    }
    
    public String getMessage() {
        if (errorType == INVALID_LINE) {
	        StringBuffer message = new StringBuffer("Validation error:\n");
	        if (number != -1)         message.append("\tline number: "+number+"\n");
	        if (line != null)         message.append("\tline       : '"+line+"'\n");
	        if (propertyName != null) message.append("\tproperty   : '"+propertyName+"'\n");
	        						  message.append("\terror      : token ");
	        if (tokenNumber != -1) message.append(tokenNumber+" (");
	        message.append("'").append(token).append("'");
	        if (tokenNumber != -1) message.append(")");
	        message.append(" failed test '").append(test).append("'");
	        return message.toString();
        } else {
            if (errorType < errorMessages.length)
            	return MessageFormat.format(errorMessages[errorType], new Object[] {msg});
            else return null;
        }
    }
}
