/*
 * Developed by eVelopers Corporation - Mar 13, 2003
 *
 * Copyright (c) 1999-2003 eVelopers Corporation. All rights reserved.
 * This software is the confidential and proprietary information of
 * eVelopers Corporation. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms of
 * the license agreement you entered into with eVelopers.
 *
 * $Date: 09-Oct-03 10:42:07$
 *
 */

package com.evelopers.common.util;

import java.io.Serializable;

/**
 * @author magus
 * @version $Revision: 1$
 * Universal ID object to be used across the framework
 */
public class ID implements Serializable {
    /**
     * Identifier field
     */
    public String id;

    /**
     * Only one allowed constructor
     * @param _id
     */
    public ID(String _id) {
        id = _id;
    }

    /**
     * @return hashcode of the id string
     */
    public int hashCode() {
        if ( id != null ) {
            return id.hashCode();
        } else {
            return 0;
        }
    }

    /**
     * Compares two ID objects
     * @param obj Object to be compared with this one
     * @return
     */
    public boolean equals(Object obj) {
        if ( (obj == null) || ((obj instanceof ID) == false) ) {
            return false;
        } else {
            return id.equalsIgnoreCase( ((ID)obj).id );
        }
    }

    /**
     * Returns string value of this object
     * @return
     */
    public String toString() {
        if ( id != null ) {
            return id.toString();
        } else {
            return null;
        }
    }

}
