/*
 * Developed by eVelopers Corporation
 *
 * $Date: 19-Jul-05 13:23:02$
 *
 */
package com.evelopers.common.util.csv;

import java.util.Properties;

import com.evelopers.common.exception.ValidationError;

/**
 * @author: aloukianova
 * @version $Revision: 1$
 */
public abstract class TokenValidator {

    /*
     * Method must implement validation of <code>token</code>. Several validation 
     * tests may be defined here. The one used for validation is defined according
     * to <code>test</code> parameter.
     * 
     * <p>In case validation fails this method must throw an Exception.
     */
    public abstract void validate(String test, String token, Properties parameters) throws ValidationError;
}
