/*
 * Developed by eVelopers Corporation
 *
 * $Date: 19-Jul-05 13:22:58$
 *
 */
package com.evelopers.common.util.csv.validators;

import java.util.Properties;

import com.evelopers.common.exception.ValidationError;
import com.evelopers.common.util.csv.TokenValidator;
import com.evelopers.common.util.csv.TokenValidatorUtils;

/**
 * TO BE DOCUMENTED!
 *
 * @author: aloukianova
 * @version $Revision: 1$
 */
public class GenericValidator extends TokenValidator {
    
    public static final String MIN = "min";
    public static final String MAX = "max";

    /**
     * @see com.evelopers.common.util.csv.TokenValidator#validate(java.lang.String, java.lang.String, java.util.Map)
     */
    public void validate(String test, String token, Properties parameters)
            throws ValidationError {
        boolean resultOK = true;
        if (test.equals(TokenValidatorUtils.REQUIRED)) {
            resultOK = validateRequired(token);
        } else if (test.equals(TokenValidatorUtils.MIN_LENGTH)) {
            resultOK = validateMinLength(token, parameters);
        } else if (test.equals(TokenValidatorUtils.MAX_LENGTH)) {
            resultOK = validateMaxLength(token, parameters);
        } else if (test.equals(TokenValidatorUtils.INT_RANGE)) {
            resultOK = validateIntRange(token, parameters);
        } else if (test.equals(TokenValidatorUtils.FLOAT_RANGE)) {
            resultOK = validateFloatRange(token, parameters);
        } else if (test.equals(TokenValidatorUtils.DOUBLE_RANGE)) {
            resultOK = validateDoubleRange(token, parameters);
        } else {
            throw new ValidationError(ValidationError.TEST_NOT_IMPLEMENTED, test);
        }
        if (!resultOK)
            throw new ValidationError(test, token);
    }
    
    protected boolean validateRequired(String token) {
        return (token != null && token.trim().length() > 0); 
    }

    protected boolean validateEmpty(String token) {
        return (token != null && token.trim().length() > 0); 
    }

    protected boolean validateIntRange(String token, Properties parameters) {
        
        if (token != null && token.trim().length() > 0) { 
            try {
                int intValue = Integer.parseInt(token);
                int min = Integer.parseInt(parameters.getProperty(MIN));
                int max = Integer.parseInt(parameters.getProperty(MAX));

                if (intValue < min || intValue > max)
                    return false;
                
            } catch (Exception e) {
                return false;
            }
        }

        return true;
    }

    protected boolean validateFloatRange(String token, Properties parameters) {
        
        if (token != null && token.trim().length() > 0) { 
            try {
                float floatValue = Float.parseFloat(token);
                float min = Float.parseFloat(parameters.getProperty(MIN));
                float max = Float.parseFloat(parameters.getProperty(MAX));

                if (floatValue < min || floatValue > max)
                    return false;
                
            } catch (Exception e) {
                return false;
            }
        }

        return true;
    }

    protected boolean validateDoubleRange(String token, Properties parameters) {
        
        if (token != null && token.trim().length() > 0) { 
            try {
                double doubleValue = Double.parseDouble(token);
                double min = Double.parseDouble(parameters.getProperty(MIN));
                double max = Double.parseDouble(parameters.getProperty(MAX));

                if (doubleValue < min || doubleValue > max)
                    return false;
                
            } catch (Exception e) {
                return false;
            }
        }

        return true;
    }

    protected boolean validateMinLength(String token, Properties parameters) {
        if (token != null) {
            try {
                int min = Integer.parseInt(parameters.getProperty(MIN));

                if (token.length() < min) {
                    return false;
                }
            } catch (Exception e) {
                return false;
            }
        }
        return true;
    }
    
    protected boolean validateMaxLength(String token, Properties parameters) {
        if (token != null) {
            try {
                int max = Integer.parseInt(parameters.getProperty(MAX));

                if (token.length() > max) {
                    return false;
                }
            } catch (Exception e) {
                return false;
            }
        }
        return true;
    }
    
}
