/*
 * Developed by eVelopers Corporation
 *
 * $Date: 19-Jul-05 13:23:01$
 *
 */
package com.evelopers.common.util.csv.validators;

import com.evelopers.common.exception.ValidationError;
import com.evelopers.common.util.csv.*;
import java.util.Properties;

/**
 * TO BE DOCUMENTED!
 *
 * @author: aloukianova
 * @version $Revision: 1$
 */
public class SimpleTypeValidator extends TokenValidator {

    /**
     * @see com.evelopers.common.util.csv.TokenValidator#validate(java.lang.String, java.lang.String, null)
     */
    public void validate(String test, String token, Properties parameters)
            throws ValidationError {
        boolean resultOK = true;
        if (test.equals(TokenValidatorUtils.BYTE)) {
            resultOK = validateByte(token);
        } else if (test.equals(TokenValidatorUtils.DOUBLE)) {
            resultOK = validateDouble(token);
        } else if (test.equals(TokenValidatorUtils.FLOAT)) {
            resultOK = validateFloat(token);
        } else if (test.equals(TokenValidatorUtils.INTEGER)) {
            resultOK = validateInteger(token);
        } else if (test.equals(TokenValidatorUtils.LONG)) {
            resultOK = validateLong(token);
        } else if (test.equals(TokenValidatorUtils.SHORT)) {
            resultOK = validateShort(token);
        } else {
            throw new ValidationError(ValidationError.TEST_NOT_IMPLEMENTED, test);
        }
        if (!resultOK)
            throw new ValidationError(test, token);
    }
    
    protected boolean validateByte(String token) {
        if (token == null) return false;
        
        try {
            new Byte(token);
            return true;
        } catch(NumberFormatException e) {
            return false;
        }    
    }

    protected boolean validateDouble(String token) {
        if (token == null) return false;
        
        try {
            new Double(token);
            return true;
        } catch(NumberFormatException e) {
            return false;
        }
    }

    protected boolean validateInteger(String token) {
        if (token == null) return false;
        
        try {
            new Integer(token);
            return true;
        } catch(NumberFormatException e) {
            return false;
        }
    }

    protected boolean validateLong(String token) {
        if (token == null) return false;
        
        try {
            new Long(token);
            return true;
        } catch(NumberFormatException e) {
            return false;
        }
    }

    protected boolean validateShort(String token) {
        if (token == null) return false;
        
        try {
            new Short(token);
            return true;
        } catch(NumberFormatException e) {
            return false;
        }
    }
    
    protected boolean validateFloat(String token) {
        if (token == null) return false;
        
        try {
            new Float(token);
            return true;
        } catch(NumberFormatException e) {
            return false;
        }
    }
}
