/*
 * Developed by eVelopers Corporation
 *
 * $Date: 19-Jul-05 13:22:34$
 *
 */
package com.evelopers.common.util.helper;

import java.lang.reflect.InvocationTargetException;

import org.apache.commons.beanutils.BeanUtils;

import com.evelopers.common.exception.CommonException;
import com.evelopers.common.exception.SystemException;

/**
 * TO BE DOCUMENTED!
 *
 * @author: aloukianova
 * @version $Revision: 1$
 */
public final class BeanHelper {

    private BeanHelper() {}
    
    public static Class beanClass(String type) throws CommonException {

        if (type == null || type.trim().length() == 0)
            throw new IllegalArgumentException("Bean type is not defined.");
            
        ClassLoader classLoader =
            Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = BeanHelper.class.getClassLoader();
        }
        try {
            return (classLoader.loadClass(type));
        } catch (Exception e) {
            return (null);
        }

    }
    
    public static void beanPopulate(Object bean, String[] values, String[] format) throws CommonException
    {
        if (format == null || values == null) return;
        
        for (int i = 0, l = format.length, l2 = values.length; i < l && i < l2; i++) {
            String value = values[i];
            
            if (value != null && value.trim().length() == 0) 
                value = null;
            
            try {
            	BeanUtils.copyProperty(bean, format[i], value);
            } catch (IllegalAccessException iae) {
            	throw new SystemException(iae, "Failed to populate bean, access error.");
            } catch (InvocationTargetException ite) {
            	throw new SystemException(ite, "Failed to populate bean, invocation error.");
            }
        }
    }
}
