/*
 * Developed by eVelopers Corporation - Oct 16, 2003
 *
 * Copyright (c) 1999-2003 eVelopers Corporation. All rights reserved.
 * This software is the confidential and proprietary information of
 * eVelopers Corporation. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms of
 * the license agreement you entered into with eVelopers.
 *
 * $Date: 14-Nov-03 14:44:56$
 *
 */

package com.evelopers.common.util.helper;

import java.io.StringWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.StringTokenizer;
import java.util.ArrayList;

/**
 *
 * @author magus
 * @version $Revision: 2$
 */
public class ExceptionHelper {

    /**
     * Private constructor to disable instances creation
     */
    private ExceptionHelper() {}

    /**
     * Prints stack trace to a string
     * @param exc
     * @return stack trace as a string or null if parameter is null
     */
    public static String getStackTrace(Throwable exc) {
        if ( exc == null ) {
            return null;
        }
        StringWriter sWriter = new StringWriter();
        exc.printStackTrace( new PrintWriter( sWriter ) );
        return sWriter.toString();
    }

    /**
     * Prints stack trace to a string and splits it separate lines
     * @param exc
     * @return stack trace as array of strings or empty array if parameter is null
     */
    public static String[] getStackTraceElements(Throwable exc) {
        String strStackTrace = getStackTrace(exc);
        if ( strStackTrace == null ) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(strStackTrace, "\n");
        List tmp = new ArrayList(16);
        while( st.hasMoreTokens() ) {
            tmp.add( st.nextToken().trim() );
        }
        return (String[]) tmp.toArray( new String[tmp.size()] );
    }

}
