/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.core.commands;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.jsch.core.JSchConnection;
import org.eclipse.remote.internal.jsch.core.commands.AbstractRemoteCommand;
import org.eclipse.remote.internal.jsch.core.messages.Messages;

public class GetOutputStreamCommand
extends AbstractRemoteCommand<OutputStream> {
    private final IPath fRemotePath;
    private final int fOptions;
    private boolean fIsClosed;

    public GetOutputStreamCommand(JSchConnection connection, int options, IPath path) {
        super(connection);
        this.fRemotePath = path;
        this.fOptions = options;
        this.fIsClosed = false;
    }

    @Override
    public OutputStream getResult(IProgressMonitor monitor) throws RemoteConnectionException {
        final SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                if (!GetOutputStreamCommand.this.fIsClosed) {
                    super.close();
                    final ByteArrayInputStream input = new ByteArrayInputStream(this.toByteArray());
                    try {
                        AbstractRemoteCommand.SftpCallable<Integer> c = new AbstractRemoteCommand.SftpCallable<Integer>((AbstractRemoteCommand)GetOutputStreamCommand.this){

                            @Override
                            public Integer call() throws JSchException, SftpException, IOException {
                                try {
                                    int mode = 0;
                                    if ((GetOutputStreamCommand.this.fOptions & 1) != 0) {
                                        mode = 2;
                                    }
                                    this.getChannel().put(input, GetOutputStreamCommand.this.fRemotePath.toString(), (SftpProgressMonitor)new AbstractRemoteCommand.CommandProgressMonitor(NLS.bind((String)Messages.GetOutputStreamCommand_Sending, (Object)GetOutputStreamCommand.this.fRemotePath.toString()), this.getProgressMonitor()), mode);
                                    input.close();
                                }
                                finally {
                                    GetOutputStreamCommand.this.fIsClosed = true;
                                }
                                return 0;
                            }
                        };
                        c.getResult((IProgressMonitor)subMon.newChild(10));
                    }
                    catch (SftpException e) {
                        throw new IOException(e.getMessage());
                    }
                    catch (CoreException e) {
                        throw new IOException(e.getMessage());
                    }
                }
            }
        };
    }
}

