/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.valgrind.launch.ValgrindLaunchPlugin;
import org.eclipse.linuxtools.internal.valgrind.ui.ValgrindUIPlugin;
import org.eclipse.swt.widgets.Display;

public class ProjectBuildListener
implements IResourceChangeListener {
    private IProject project;

    public ProjectBuildListener(IProject targetProject) {
        this.project = targetProject;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.project != null && this.isPostBuildEvent(event)) {
            IResourceDelta[] childrenDelta;
            IResourceDelta delta = event.getDelta();
            IResourceDelta[] iResourceDeltaArray = childrenDelta = delta.getAffectedChildren(4);
            int n = childrenDelta.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta childDelta = iResourceDeltaArray[n2];
                if (this.isProjectDelta(childDelta, this.project)) {
                    this.clearProjectMarkers(this.project);
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
                }
                ++n2;
            }
        }
    }

    private boolean isProjectDelta(IResourceDelta delta, IProject project) {
        if (delta != null) {
            IResource resource = delta.getResource();
            return delta.getKind() == 4 && resource != null && resource.getType() == 4 && resource.equals((Object)project);
        }
        return false;
    }

    private boolean isPostBuildEvent(IResourceChangeEvent event) {
        if (event != null) {
            int buildKind = event.getBuildKind();
            return event.getType() == 16 && (buildKind == 6 || buildKind == 10 || buildKind == 15);
        }
        return false;
    }

    private void clearProjectMarkers(IProject project) {
        try {
            project.deleteMarkers("org.eclipse.linuxtools.valgrind.launch.marker", true, 2);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ValgrindUIPlugin.getDefault().resetView();
                }
            });
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.linuxtools.valgrind.launch", e.getMessage());
            ValgrindLaunchPlugin.getDefault().getLog().log((IStatus)status);
        }
    }
}

