/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog.structures;

import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.Localization;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ConsoleStreamDaemon;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.IErrorParser;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ScriptConsole;
import org.eclipse.linuxtools.systemtap.ui.consolelog.views.ErrorView;

public class ErrorStreamDaemon
extends ConsoleStreamDaemon {
    private ErrorView errorView;
    private StringBuilder outputData = new StringBuilder();
    private IErrorParser parser;

    public ErrorStreamDaemon(ScriptConsole console, ErrorView errorWindow, IErrorParser parser) {
        super(console);
        this.parser = parser;
        if (errorWindow != null) {
            this.errorView = errorWindow;
            this.errorView.clear();
        }
    }

    @Override
    protected void pushData() {
        String[][] errors;
        if (this.output.startsWith(Localization.getString("ErrorStreamDaemon.Password"))) {
            this.output = this.output.substring(Localization.getString("ErrorStreamDaemon.Password").length());
        }
        super.pushData();
        this.outputData.append(this.output);
        if (this.errorView != null && (errors = this.parser.parseOutput(this.outputData.toString())) != null) {
            this.errorView.clear();
            String[][] stringArray = errors;
            int n = errors.length;
            int n2 = 0;
            while (n2 < n) {
                String[] error = stringArray[n2];
                this.errorView.add(error);
                ++n2;
            }
        }
    }

    @Override
    public void dispose() {
        if (!this.isDisposed()) {
            super.dispose();
            this.errorView = null;
            this.outputData.delete(0, this.outputData.length());
            this.outputData = null;
            this.parser = null;
        }
    }
}

