/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.linuxtools.internal.rpm.ui.editor.Activator;
import org.eclipse.linuxtools.internal.rpm.ui.editor.preferences.PreferenceConstants;
import org.eclipse.linuxtools.rpm.core.utils.Utils;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileDefine;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfilePackage;

public class UiUtils {
    public static void pluginSanityCheck() throws IOException {
        boolean exists = new File(PreferenceConstants.RPMMACRO_FILE).exists();
        if (!exists && Utils.fileExist((String)"/usr/bin/rpmdev-setuptree")) {
            Utils.runCommandToInputStream((String[])new String[]{"rpmdev-setuptree"});
        }
        String currentRpmTool = Activator.getDefault().getPreferenceStore().getString("currentRpmtools");
        if (!Utils.fileExist((String)"/usr/bin/yum")) {
            if (currentRpmTool.equals("yum -C list all | grep - | cut -d \".\" -f 1")) {
                Activator.getDefault().getPreferenceStore().setValue("currentRpmtools", "rpm -qa --qf '%{NAME}\\n'");
            }
        } else if (!Utils.fileExist((String)"/usr/bin/urpmq") && currentRpmTool.equals("urpmq --list")) {
            Activator.getDefault().getPreferenceStore().setValue("currentRpmtools", "rpm -qa --qf '%{NAME}\\n'");
        }
    }

    public static String resolveDefines(Specfile specfile, String stringToResolve) {
        String workingString = stringToResolve;
        try {
            Pattern variablePattern = Pattern.compile("%\\{(\\S+?)\\}");
            Matcher variableMatcher = variablePattern.matcher(stringToResolve);
            HashSet variablesFound = new HashSet();
            while (variableMatcher.find()) {
                SpecfileDefine define;
                String variable = variableMatcher.group(1);
                if (variablesFound.contains(variable) || (define = specfile.getDefine(variable)) == null || stringToResolve.equals(define.getUnresolvedStringValue())) continue;
                workingString = workingString.replaceAll("\\%\\{" + variable + "\\}", define.getStringValue());
            }
            return workingString;
        }
        catch (Exception e) {
            return stringToResolve;
        }
    }

    public static String getPackageDefineId(SpecfileDefine define, SpecfilePackage rpmPackage) {
        return UiUtils.getPackageDefineId(define.getName(), rpmPackage);
    }

    public static String getPackageDefineId(String defineName, SpecfilePackage rpmPackage) {
        return String.valueOf(defineName.toLowerCase()) + ':' + rpmPackage.getPackageName();
    }
}

