/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.opxml.modeldata;

import java.util.ArrayList;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelImage;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.OprofileSAXHandler;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.XMLProcessor;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.modeldata.SymbolsProcessor;
import org.xml.sax.Attributes;

public class DependentProcessor
extends XMLProcessor {
    private static final String IMAGE_TAG = "image";
    private static final String SYMBOLS_TAG = "symbols";
    private static final String DEPENDENT_TAG = "dependent";
    private static final String ATTR_IMAGENAME = "name";
    private static final String ATTR_COUNT = "count";
    private OpModelImage image;
    private ArrayList<OpModelImage> imageList;
    private SymbolsProcessor _symbolsProcessor = new SymbolsProcessor();

    @Override
    public void reset(Object callData) {
        this.image = new OpModelImage();
        this.imageList = new ArrayList();
    }

    @Override
    public void startElement(String name, Attributes attrs, Object callData) {
        if (name.equals(IMAGE_TAG)) {
            this.image.setName(this.validString(attrs.getValue(ATTR_IMAGENAME)));
            this.image.setCount(Integer.parseInt(attrs.getValue(ATTR_COUNT)));
        } else if (name.equals(SYMBOLS_TAG)) {
            OprofileSAXHandler.getInstance(callData).push(this._symbolsProcessor);
        }
    }

    @Override
    public void endElement(String name, Object callData) {
        if (name.equals(IMAGE_TAG)) {
            this.imageList.add(this.image);
            this.image = new OpModelImage();
        } else if (name.equals(SYMBOLS_TAG)) {
            this.image.setSymbols(this._symbolsProcessor.getSymbols());
        } else if (name.equals(DEPENDENT_TAG)) {
            OprofileSAXHandler.getInstance(callData).pop(DEPENDENT_TAG);
        }
    }

    public OpModelImage[] getImages() {
        OpModelImage[] images = new OpModelImage[this.imageList.size()];
        this.imageList.toArray(images);
        return images;
    }
}

