/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.osview;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.dsf.gdb.service.IGDBHardwareAndOS2;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

class OSData
extends LabelProvider
implements ITableLabelProvider,
IStructuredContentProvider {
    private IGDBHardwareAndOS2.IResourcesInformation data;
    private boolean[] columnIsInteger;
    private List<Integer> remap;

    public OSData(String resourceClass, IGDBHardwareAndOS2.IResourcesInformation data) {
        this.data = data;
        this.determineColumnTypes();
        this.remap = new ArrayList<Integer>(data.getColumnNames().length);
        int i = 0;
        while (i < data.getColumnNames().length) {
            this.remap.add(i);
            ++i;
        }
        if (resourceClass.equals("processes")) {
            this.sendToEnd("Command");
        }
        if (resourceClass.equals("threads")) {
            this.sendToEnd("Command");
        }
        if (resourceClass.equals("modules")) {
            this.sendToEnd("Dependencies");
        }
    }

    private void determineColumnTypes() {
        String[] columnNames = this.data.getColumnNames();
        String[][] content = this.data.getContent();
        this.columnIsInteger = new boolean[columnNames.length];
        boolean[] columnHasInteger = new boolean[columnNames.length];
        boolean[] columnHasOther = new boolean[columnNames.length];
        int i = 0;
        while (i < content.length) {
            int j = 0;
            while (j < content[i].length) {
                if (!columnHasOther[j]) {
                    try {
                        Integer.parseInt(content[i][j]);
                        columnHasInteger[j] = true;
                    }
                    catch (NumberFormatException e) {
                        columnHasOther[j] = true;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < this.data.getColumnNames().length) {
            this.columnIsInteger[j] = columnHasInteger[j] && !columnHasOther[j];
            ++j;
        }
    }

    private void sendToEnd(String column) {
        int index = -1;
        int i = 0;
        while (i < this.remap.size()) {
            if (this.data.getColumnNames()[this.remap.get(i)].equals(column)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        this.remap.add(this.remap.remove(index));
    }

    public int getColumnCount() {
        return this.remap.size();
    }

    public String getColumnName(int i) {
        return this.data.getColumnNames()[this.remap.get(i)];
    }

    public boolean getColumnIsInteger(int j) {
        return this.columnIsInteger[this.remap.get(j)];
    }

    public String getColumnText(Object obj, int index) {
        return ((String[])obj)[this.remap.get(index)];
    }

    public Image getColumnImage(Object obj, int index) {
        return this.getImage(obj);
    }

    public Image getImage(Object obj) {
        return null;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        return this.data.getContent();
    }
}

